local ThemeDir = THEME:GetCurrentThemeDirectory()
local PlayingBGM = false
local BGM = nil

local ResetMusicDefaults = function()
	return {
		start = 0,
		fadeIn = 0,
		fadeOut = 0,
		loop = true,
		applyRate = true,
		alignBeat = true,
	}
end

return Def.Actor{
	Name="BGM",
	InitCommand=function(self)
		SRT.BGM = self
	end,
	OnCommand=function(self)
		self:queuecommand("Set")
	end,
	SetCommand=function(self)
		BGM = ResetMusicDefaults()
		for key,value in pairs( SRT.EventData.BGM ) do
			BGM[key] = value
		end
		self:queuecommand("Play")
	end,
	PlayCommand=function(self)
		if BGM then
			SOUND:PlayMusicPart(ThemeDir .. "Sounds/" .. BGM.file, BGM.start, BGM.length, BGM.fadeIn, BGM.fadeOut, BGM.loop, BGM.applyRate, BGM.alignBeat)
			PlayingBGM = true
		end
	end,
	StopCommand=function(self)
		SOUND:StopMusic()
		PlayingBGM = false
	end,
	ToggleCommand=function(self)
		if PlayingBGM then
			self:playcommand("Stop")
			SM("Audio toggled off.")
		else
			self:playcommand("Play")
			SM("Audio toggled on.")
		end
	end
}